/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.libzoomer.mixin;

import io.github.ennuil.libzoomer.api.ZoomInstance;
import io.github.ennuil.libzoomer.api.ZoomRegistry;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_757;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_757.class})
public class GameRendererMixin {
    @Shadow
    @Final
    private class_310 field_4015;

    @Inject(at={@At(value="HEAD")}, method={"tick()V"})
    private void tickInstances(CallbackInfo info) {
        boolean iterateZoom = false;
        boolean iterateTransitions = false;
        boolean iterateModifiers = false;
        boolean iterateOverlays = false;
        for (ZoomInstance instance : ZoomRegistry.getZoomInstances()) {
            boolean zoom = instance.getZoom();
            if (zoom || instance.isTransitionActive() || instance.isOverlayActive()) {
                double divisor;
                double d = divisor = zoom ? instance.getZoomDivisor() : 1.0;
                if (instance.getZoomOverlay() != null) {
                    instance.getZoomOverlay().tick(zoom, divisor, instance.getTransitionMode().getInternalMultiplier());
                }
                instance.getTransitionMode().tick(zoom, divisor);
            }
            iterateZoom = iterateZoom || zoom;
            iterateTransitions = iterateTransitions || instance.isTransitionActive();
            iterateModifiers = iterateModifiers || instance.isModifierActive();
            iterateOverlays = iterateOverlays || instance.isOverlayActive();
        }
        ZoomRegistry.setIterateZoom(iterateZoom);
        ZoomRegistry.setIterateTransitions(iterateTransitions);
        ZoomRegistry.setIterateModifiers(iterateModifiers);
        ZoomRegistry.setIterateOverlays(iterateOverlays);
    }

    @Inject(at={@At(value="RETURN")}, method={"getFov(Lnet/minecraft/client/render/Camera;FZ)D"}, cancellable=true)
    private void getZoomedFov(class_4184 camera, float tickDelta, boolean changingFov, CallbackInfoReturnable<Double> cir) {
        double fov;
        double zoomedFov = fov = ((Double)cir.getReturnValue()).doubleValue();
        if (ZoomRegistry.shouldIterateTransitions()) {
            for (ZoomInstance instance : ZoomRegistry.getZoomInstances()) {
                if (!instance.isTransitionActive()) continue;
                zoomedFov = instance.getTransitionMode().applyZoom(zoomedFov, tickDelta);
            }
        }
        if (fov != zoomedFov) {
            cir.setReturnValue((Object)zoomedFov);
        }
    }
}

